# Code Changes
# Revised 11/16/2025 for Moodle 5.1
# This is very specific to Rick's chaanges.

# Variables:
# www = web root (public_html, htdocs, docroot, etc.)
#www=~/htdocs # MAMP
www=~/public_html # VPS
# Location of the Moodle code (i.e, the mooodle app)
mdl_code_folder=moodle5 # VPS and MAMP
# Folder where the new Moodle is prepared.
#temp_folder=~/mdl_temp # MAMP
temp_folder=~/mdl_temp # VPS
# If Moodle 5.0 or earlier, mdl_code_location="public_html". If Moodle 5.1, mdl_code_location="mdl_sites"
#mdl_code_location=~/mdl_sites # VPS and MAMP and future upgrades.
mdl_code_location=~/public_html # First transition to 5.1
# Important: Change to mdl_public_folder ("", for pre-5.1, "public" post 5.1)
# mdl_public_folder="public" # After Moodle 5.1 tansition
mdl_public_folder="" # First transition to 5.1

# Make the following "code" changes.
#   Note: You need to know what you are doing for code changes.
echo "Code Changes"
echo "------------"
# Note: In MacOS, you need the '.bak' in the sed command.
#   Since a ".bak" file is created, I remove the .bak file.
#		In UNIX (vs08) I use a more standard form of the SED command.

# Modify Boost so that the home icon goes to a web page external to moodle.
#   A direct URL to edu-gen.com.
echo "Modify Boost navbar.mustache file with direct URL to homepage."
sed -i 's`{{{ config.homeurl }}}`https://www.edu-gen.com`' $temp_folder/$mdl_code_folder/public/theme/boost/templates/navbar.mustache

# Modify Boost to remove the courseindex block.
echo "Modify Boost drawers.php file to not display the courseindex."
sed -i "s/(get_user_preferences('drawer-open-index', true) == true)/false/" $temp_folder/$mdl_code_folder/public/theme/boost/layout/drawers.php

# Done making code changes
